program Listing4;

uses
  RTTI, System.SysUtils, TypInfo, System.Classes, System.StrUtils;

type
  TPrzydatnyInterfejs = class(TVirtualInterface)
    constructor Create(PIID: PTypeInfo);
    procedure WywołajMetodę(Metoda: TRttiMethod; const Argumenty: TArray<TValue>;
      out Wynik: TValue);
  end;

constructor TPrzydatnyInterfejs.Create(PIID: PTypeInfo);
begin
  inherited Create(PIID, WywołajMetodę);
end;

procedure TPrzydatnyInterfejs.WywołajMetodę(Metoda: TRttiMethod;
    const Argumenty: TArray<TValue>; out Wynik: TValue);
begin
  if UpperCase(Metoda.Name) = 'WITAJ' then
  begin
    WriteLn('Witaj świecie!');
  end else
  begin
    if UpperCase(Metoda.Name) = 'TEKSTWSTECZ' then
    begin
      Wynik := ReverseString(Argumenty[1].AsString)
    end else
    begin
      if UpperCase(Metoda.Name) = 'ILOCZYN' then
      begin
        Wynik := Argumenty[1].AsInteger * Argumenty[2].AsInteger;
      end else
      begin
        raise Exception.Create('Błędny parametr metody WywołajMetodę');
      end;
    end;
  end;
end;


type
  IPrzydatnyInterfejs = interface(IInvokable)
    ['{16F01BF0-961F-4461-AEBE-B1ACB8D3F0F4}']
    procedure Witaj;
    function TekstWstecz(aTekst: string): string;
    function Iloczyn(x, y: integer): integer;
  end;

var
  PrzydatnyInterfejs: IPrzydatnyInterfejs;
begin
  PrzydatnyInterfejs := TPrzydatnyInterfejs.Create(TypeInfo(IPrzydatnyInterfejs)) as IPrzydatnyInterfejs;
  PrzydatnyInterfejs.Witaj;
  WriteLn(PrzydatnyInterfejs.TekstWstecz('Przykładowy tekst'));
  WriteLn(PrzydatnyInterfejs.Iloczyn(6, 7));
  ReadLn;
end.